// Macro converts a sequence of TLZ images to 8-bit format
// for calculationts of enzyme activity using Activity.m
// The greyscale values are corrected for background with noise reducing by Median 3D filter
// Resulting sequence should be saved to MUF sub-dirrectory by user 

run("Close All"); 
// Open TLZ imagges
source_dir = getDirectory("Source Directory");
stack1=source_dir+File.separator;
list = getFileList(stack1);
fileone=stack1 + list[0];
nummer=list.length;
run("Image Sequence...", "open=fileone number=nummer starting=1 increment=1 scale=100 file=[] or=[] sort");

// select zymography area on the image using rectangle selection tool 
waitForUser("Select ROI and click OK")
fileROI = source_dir + "Selection.roi";
saveAs("Selection", fileROI);
run("Duplicate...", "title=Cropped duplicate");

// Select Channel use for zymography 
  Channel = newArray("All","R", "G", "B");
  Dialog.create("Select Channel");
  Dialog.addChoice("Channel:", Channel);
  Dialog.show();
  Channel = Dialog.getChoice();
print(Channel);

// Get calibration image in selected color  
if(Channel=="All") {
run("8-bit");
rename("Channel");
}
else {
run("Split Channels");
if(Channel=="R") {
selectWindow("Cropped (red)");
run("Duplicate...", "title=Channel duplicate");
}
if(Channel=="G") {
selectWindow("Cropped (green)");
run("Duplicate...", "title=Channel duplicate");
}
if(Channel=="B") {
selectWindow("Cropped (blue)");
run("Duplicate...", "title=Channel duplicate");
}
selectWindow("Cropped (red)");
close();
selectWindow("Cropped (blue)");
close();
selectWindow("Cropped (green)");
close();
selectWindow("RAW");
close();
}

// Subtract the first image (background) from the whole sequence
selectWindow("Channel");
setSlice(1);
run("Duplicate...", "title=img_1");
imageCalculator("Subtract create stack", "Channel","img_1");

// Remove noise
run("Median 3D...", "x=3 y=3 z=3");
rename("MUF_filt");

// Save processed images in new directory
waitForUser("Save processed images to MUF directory");

  
  macro "Close All Windows" { 
      while (nImages>0) { 
          selectImage(nImages); 
          close(); 
      } 
  } 